% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CogapsResult.R, R/methods-CogapsResult.R
\docType{methods}
\name{getPatternGeneSet}
\alias{getPatternGeneSet}
\alias{getPatternGeneSet,CogapsResult,list,character-method}
\title{generate statistics associating patterns with gene sets}
\usage{
getPatternGeneSet(
  object,
  gene.sets,
  method = c("enrichment", "overrepresentation"),
  ...
)

\S4method{getPatternGeneSet}{CogapsResult,list,character}(
  object,
  gene.sets,
  method = c("enrichment", "overrepresentation"),
  ...
)
}
\arguments{
\item{object}{an object of type CogapsResult}

\item{gene.sets}{a list of gene sets to test. List names should be the names of the gene sets}

\item{method}{enrichment or overrepresentation. Conducts a test for gene set enrichment using {fgsea::gsea} ranking features by pattern amplitude or a test for gene set overrepresentation in pattern markers using {fgsea::fora}, respectively.}

\item{...}{additional parameters passed to {patternMarkers} if using overrepresentation method}
}
\value{
list of dataframes containing gene set enrichment or gene set overrepresentation statistics
}
\description{
generate statistics associating patterns with gene sets
}
\examples{
data(GIST)
gs.test <- list(
"gs1" = c("Hs.2", "Hs.4", "Hs.36", "Hs.96", "Hs.202"),
"gs2" = c("Hs.699463", "Hs.699288", "Hs.699280", "Hs.699154", "Hs.697294")
)
getPatternGeneSet(object = GIST.result, gene.sets = gs.test, method = "enrichment")
getPatternGeneSet(object = GIST.result, gene.sets = gs.test, method = "overrepresentation")
}
