% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Methods.R
\name{plotSANKEY}
\alias{plotSANKEY}
\alias{plotSANKEY,ClustAllObject,character,logicalOrNA-method}
\title{Visualize Stratification Comparisons with Sankey Diagram}
\usage{
plotSANKEY(Object, clusters, validationData = FALSE)
}
\arguments{
\item{Object}{A processed \code{\link{ClustAllObject-class}} object. The object
must have been processed by \code{\link{runClustAll}} before using this function.}

\item{clusters}{A character vector specifying the names of stratifications to compare.
If validationData is FALSE, exactly two stratification names should be provided.
If validationData is TRUE, provide one stratification name to compare with true labels.}

\item{validationData}{Logical. If TRUE, compares the specified stratification with
the true labels (validation data) if available. Default is FALSE.}
}
\value{
A Sankey plot showing the composition and flow of clusters between
the selected stratifications. If true labels are available and
“validationData” is TRUE, the plot will compare the selected stratification
against the true labels.
}
\description{
This function generates a Sankey diagram to visualize the relationships between
different stratifications or between a stratification and the true labels (if available).
It provides an intuitive representation of how samples are distributed across
clusters in different stratifications or how they align with known stratifications.
}
\details{
The plotSANKEY function provides a powerful visualization tool for understanding
the relationships between different clustering solutions or between a clustering
solution and known classifications:

\enumerate{
  \item Stratification Comparison (validationData = FALSE):
  \itemize{
    \item Visualizes how samples are distributed across clusters in two different stratifications.
    \item Helps identify similarities and differences between clustering solutions.
    \item Useful for understanding how changes in clustering parameters affect sample groupings.
  }

  \item Validation Comparison (validationData = TRUE):
  \itemize{
    \item Compares a single stratification with true labels (if available).
    \item Helps assess how well the clustering aligns with known stratifications.
    \item Useful for evaluating the biological or clinical relevance of a clustering solution.
  }
}

The Sankey diagram represents:
\itemize{
  \item Clusters (or true labels) as nodes on the left and right sides of the diagram.
  \item Flows between nodes indicating how samples are distributed.
  \item The width of each flow is proportional to the number of samples it represents.
}

This visualization is particularly useful for:
\itemize{
  \item Identifying stable sample groupings across different stratifications.
  \item Detecting major shifts in cluster assignments between solutions.
  \item Evaluating the concordance between clustering results and known stratifications.
  \item Understanding the impact of different clustering approaches on sample groupings.
}
}
\note{
\itemize{
  \item This function requires a processed ClustAllObject. Ensure
    \code{\link{runClustAll}}
    has been executed before using plotSANKEY.
  \item When validationData is TRUE, the ClustAllObject must contain validation data
    (true labels). This can be added using \code{\link{addValidationData}} if not
    provided during object creation.
  \item Stratification names can be obtained from the results of
    \code{\link{resStratification}}
    or by examining the names in the summary_clusters slot of the ClustAllObject.
  \item The Sankey diagram may become cluttered if there are many clusters or if the
    clustering solutions are very different. In such cases, consider focusing on
    specific subsets of clusters or using additional filtering criteria.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
label <- as.numeric(as.factor(wdbc$Diagnosis))
wdbc <- subset(wdbc,select=c(-ID, -Diagnosis))
wdbc <- wdbc[1:15,1:8]
label <- label[16:30]
obj_noNA <- createClustAll(data = wdbc)
\donttest{
obj_noNA1 <- runClustAll(Object = obj_noNA, threads = 1, simplify = TRUE)
resStratification(Object = obj_noNA1, population = 0.05,
                  stratification_similarity = 0.88, all = FALSE)
plotSANKEY(Object = obj_noNA1, clusters = c("cuts_a_1","cuts_b_5"))

obj_noNA1 <- addValidationData(obj_noNA1, label)
plotSANKEY(Object = obj_noNA1, clusters = "cuts_a_1", validationData=TRUE)
}

}
\seealso{
\code{\link{runClustAll}}, \code{\link{resStratification}},
\code{\link{addValidationData}}, \code{\link{ClustAllObject-class}}
}
