% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{getSpectrum}
\alias{getSpectrum}
\title{Access individual spectra from a list of spectra by various slot entries}
\usage{
getSpectrum(featlist, slot, what, mz.tol = 1e-05, rt.tol = 30)
}
\arguments{
\item{featlist}{a list that contains only objects of class
\code{\linkS4class{MS2spectrum}}}

\item{slot}{The slot to be searched (invalid slot arguments will produce
errors). Possible values are: \itemize{ \item \code{'id'} \item
\code{'annotation'} \item \code{'precursor'} (\emph{m/z} of precursor ion)
\item \code{'rt'} (retention time of precursor) }}

\item{what}{the search term or number, must be character for \code{'id'} and
\code{'annotation'} and numeric for \code{'precursor'} and \code{'rt'} See
vignette for examples.}

\item{mz.tol}{the tolerance used for precursor ion *m/z* searches, defaults
to \code{1E-05} (+/- 10ppm)}

\item{rt.tol}{the tolerance used for precursor ion retention time searches,
defaults to 30s; high values can be used to specify retention time ranges
(see vignette for example)}
}
\value{
If the only one spectrum matches the search criteria, the output is
    an object of class \code{\linkS4class{MS2spectrum}}; if more than one
    spectrum matches, the output is a list of \code{\linkS4class{MS2spectrum}}
    objects.
}
\description{
As accessing S4 objects within lists is not trivial, \code{getSpectrum} can
be used to access individual or several \code{\linkS4class{MS2spectrum}}
objects by their slot entries.
}
\examples{
load(file = system.file("extdata",
    "annotatedSpeclist.RData",
    package = "CluMSIDdata"))

getSpectrum(annotatedSpeclist, "annotation", "pyocyanin")

getSpectrum(annotatedSpeclist, "id", "M244.17T796.4")

getSpectrum(annotatedSpeclist, "precursor", 286.18, mz.tol = 1E-03)

six_eight <- getSpectrum(annotatedSpeclist, "rt", 420, rt.tol = 60)

}
