% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudospectra.R
\name{extractPseudospectra}
\alias{extractPseudospectra}
\title{Extract pseudospectra}
\usage{
extractPseudospectra(x, min_peaks = 1, intensity_columns = NULL)
}
\arguments{
\item{x}{\pkg{CAMERA} output that contains information on pseudospectra.
Can either be of class \code{data.frame} or
\code{\link[CAMERA]{xsAnnotate}}.
It is recommended to use either \code{xsAnnotate} objects or
\code{data.frame}s generated from XCMSonline results tables but
other \code{data.frame}s are possible.}

\item{min_peaks}{Minimum number of peaks in pseudospectrum, defaults to
\code{1}. See \code{\link{extractMS2spectra}}.}

\item{intensity_columns}{Numeric, defaults to \code{NULL}.
If a \code{data.frame} is used as input which has not been
generated from an XCMSonline results table, the indices
of the columns that contain the peak intensities in the
different samples have to be indicated as
\code{intensity_columns}.}
}
\value{
A list of pseudospectra, stored as objects of class
\code{\linkS4class{pseudospectrum}}, analogous to the output of
\code{\link{extractMS2spectra}}.
}
\description{
\code{extractPseudospectra()} is used to extract MS1 pseudospectra from
\pkg{CAMERA} output.
}
\examples{
pstable <- readr::read_delim(file = system.file("extdata",
                                "TD035_XCMS.annotated.diffreport.tsv",
                                package = "CluMSIDdata"), delim = "\\t")

pseudospeclist <- extractPseudospectra(pstable, min_peaks = 2)

}
