% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_clustering.R
\name{HCplot}
\alias{HCplot}
\title{Generate cluster dendrogram or heatmap from spectral similarity data}
\usage{
HCplot(distmat, h = 0.95, type = c("dendrogram", "heatmap"), ...)
}
\arguments{
\item{distmat}{A distance matrix as generated by
\code{\link{distanceMatrix}}.}

\item{h}{Height where the tree is to be cut, defaults to \code{0.95}.
See \code{\link[stats]{cutree}} for details.}

\item{type}{Specifies which visualisation is to be generated:
\code{"dendrogram"} (default) for a circular dendrogram or
\code{"heatmap"} for a combination of dendrogram and heatmap.}

\item{...}{Additional graphical parameters passed to
\code{plot.phylo} (for \code{type = "dendrogram"})
or \code{gplots::heatmap.2} (for \code{type = "heatmap"})}
}
\value{
A plot as specified by \code{type}.
}
\description{
\code{HCplot()} performs hierarchical clustering
of spectral similarity data using average linkage
as agglomeration criterion like \code{\link{HCtbl}}
and generates either a circular dendrogram or a
combination of dendrogram and heatmap.
}
\examples{
load(file = system.file("extdata",
    "distmat.RData",
    package = "CluMSIDdata"))

HCplot(distmat[1:50,1:50], h = 0.8, type = "heatmap")

}
