% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gDNA.R
\name{plot_expr_distr}
\alias{plot_expr_distr}
\title{Visualize expression distribution}
\usage{
plot_expr_distr(
  SummarizedCounts = NULL,
  normalization = c("DESeq2", "qsmooth", "none")
)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}..}

\item{normalization}{A character(1) vector, specifying a between-sample
normalization methods: DESeq2's  median of ratios method, smooth quantile
normalization method \code{\link[qsmooth:qsmooth]{qsmooth::qsmooth()}}, or \code{none}.}
}
\value{
A list of 3 ggplot objects.
\describe{
\item{box_plot}{boxplots showing DESeq2-normalized gene-level count
distribution, on a log scale}
\item{density_plot}{density plots showing DESeq2-normalized gene-level
count distribution, on a log scale}
\item{ecd_plot}{plots showing empricial cumulative distribution of
fraction  of genes with CPM greater than or equal to a
given CPM on a log scale}
}
}
\description{
Compare expression distribution by boxplot, density plot and empirical
cumulative distribution plot.
}
\examples{
\dontshow{if (require("patchwork")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lib_strand <- 0
col_data_f <- system.file("extdata", "example.colData.txt",
                         package = "CleanUpRNAseq")
col_data <- read.delim(col_data_f, as.is = TRUE)
## create fake bam files
tmp_dir <- tempdir()
bamfiles <- gsub(".+/", "", col_data$BAM_file)
null <- lapply(file.path(tmp_dir, bamfiles), file.create)
## create fake quant.sf files
quant_sf <- file.path(tmp_dir, gsub(".srt.bam$",
                                    "quant.sf",
                                    bamfiles))
null <- lapply(quant_sf, file.create)
col_data$BAM_file <- file.path(tmp_dir, bamfiles)
col_data$salmon_quant_file <- quant_sf

## pretend this is stranded RA=NA-seq data
col_data$salmon_quant_file_opposite_strand <- quant_sf

sc <- create_summarizedcounts(lib_strand, col_data)

data("feature_counts_list")
data("salmon_quant")

sc$set_feature_counts(feature_counts_list)
sc$set_salmon_quant(salmon_quant)
sc$set_salmon_quant_opposite(salmon_quant)

wrap_plots(plot_expr_distr(SummarizedCounts = sc,
                normalization = "DESeq2"), ncol = 1)
\dontshow{\}) # examplesIf}
}
