% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_methods.R
\name{correct_global}
\alias{correct_global}
\title{Global correction for DNA contamination}
\usage{
correct_global(SummarizedCounts = NULL, lambda = 1)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}..}

\item{lambda}{A positive number specifying how many times of the median read
coverage of non-zero count intergenic regions used as an estimate of DNA
contamination. The default of \emph{lambda} is 1,but it could be adjusted based
on the gene-level count distributions of the resulting corrected count
table output by the \code{\link[=plot_read_distr]{plot_read_distr()}} function. A value between
1 and 3 can be tried. Ideally the distributions of all samples from a
given condition should be very similar.}
}
\value{
A matrix containing an RNA-seq count table corrected for DNA
contamination, with rows for genes and columns for samples.
}
\description{
Correct for DNA contamination in RNA-seq data using the 2.5 times of median
counts per base of intergenic regions with at least one count.
}
\examples{
lib_strand <- 0
col_data_f <- system.file("extdata", "example.colData.txt",
                         package = "CleanUpRNAseq")
col_data <- read.delim(col_data_f, as.is = TRUE)
## create fake bam files
tmp_dir <- tempdir()
bamfiles <- gsub(".+/", "", col_data$BAM_file)
null <- lapply(file.path(tmp_dir, bamfiles), file.create)
## create fake quant.sf files
quant_sf <- file.path(tmp_dir, gsub(".srt.bam$",
                                    "quant.sf",
                                    bamfiles))
null <- lapply(quant_sf, file.create)
col_data$BAM_file <- file.path(tmp_dir, bamfiles)
col_data$salmon_quant_file <- quant_sf

## pretend this is stranded RA=NA-seq data
col_data$salmon_quant_file_opposite_strand <- quant_sf

sc <- create_summarizedcounts(lib_strand, col_data)

data("feature_counts_list")
data("salmon_quant")

sc$set_feature_counts(feature_counts_list)
sc$set_salmon_quant(salmon_quant)
sc$set_salmon_quant_opposite(salmon_quant)
corrected_counts <- correct_global(SummarizedCounts = sc)

}
