% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_class.R
\docType{class}
\name{SummarizedCounts}
\alias{SummarizedCounts}
\title{SummarizedCounts Object}
\format{
An R6 class
}
\description{
A class for storing and retrieving summarized RNA-seq data.
}
\section{Constructors}{

Create an object of \link{SummarizedCounts} by setting \code{lib_strand} and
\code{col_data}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- SummarizedCounts$new(lib_strand = 0,
                          col_data = "colData in a tab-delimited txt file")
}\if{html}{\out{</div>}}

Alternatively, users can call the wrapper function
\code{\link[=create_summarizedcounts]{create_summarizedcounts()}} to construct an object of
\link{SummarizedCounts}.
}

\section{Setting and getting fields}{


The library stranded information, \code{colData}, and corrected expression
data of a SummarizedCounts object, \code{x}, can be simply accessed as follows:
'''r
x$lib_strand
x$col_data
x$global_correction
x$gc_correction
x$ir_correction
x$stranded_correction

\if{html}{\out{<div class="sourceCode">}}\preformatted{
The field and sub-fields of featureCounts-summarized RNA-seq data can be
set and get as follows. The feature_counts list contains the following
elements: "gene", "exon", "intergenic_region", "intronic_region", "rRNA",
"mitochondrion", "gtf", "chloroplast". For genomic features, gene, exon,
intron, rRNA, mitochondrion, and chloroplast, only the `stat` elements of
the [Rsubread::featureCounts()] oupt is stored; for intergenic region,
the `stat`, `annotation` and `counts` elements are stored; for GTF-based
summarization, the `stat` and `counts` elements are stored.

```r
## the whole feature_counts list
x$set_feature_counts(feature_counts_list)
x$get_feature_counts()

## gene-coding regions: intron + exons
x$get_gene_stat ()

## exons
x$get_exon_stat()

## intergenic region summaries
x$get_ir_stat()
x$get_ir_counts()
x$get_ir_anno()

## intronic regions
x$get_intron_stat()

## rRNA-coding regions
x$get_rRNA_stat()

## mitochondrion
x$get_mt_stat()

## chloroplast
x$get_ct_stat()

## GTF meta-gene, exons as features
x$get_gtf_stat()
x$get_gtf_counts()
}\if{html}{\out{</div>}}

Adding Salmon quantification data (setting the library type information
to the opposite type) to the SummarizedCounts object. For library type
information, see https://salmon.readthedocs.io/en/latest/library_type.html.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x$set_salmon_quant(tximport_list)
x$get_salmon_quant()
x$get_salmon_counts()
x$get_salmon_abundance()
x$get_salmon_length()
}\if{html}{\out{</div>}}

Adding Salmon quantification data (setting the library type information
to the opposite type) to the SummarizedCounts object. For library type
information, see https://salmon.readthedocs.io/en/latest/library_type.html.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x$set_salmon_quant_opposite(tximport_list)
x$get_salmon_quant_opposite()
x$get_salmon_opposite_counts()
x$get_salmon_opposite_abundance()
}\if{html}{\out{</div>}}

Adding corrected expression data to the SummarizedCounts object:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x$set_global_correction(corrected_expr)
x$set_gc_correction(corrected_expr)
x$set_ir_correction(corrected_expr)
x$set_stranded_correction(salmon_correction)
}\if{html}{\out{</div>}}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lib_strand}}{(\code{integer(1)})\cr
Library strandedness, which can be 0, 1, or 2. See
\code{\link[=create_summarizedcounts]{create_summarizedcounts()}}.}

\item{\code{col_data}}{(\code{data.frame})\cr
colData for RNA-seq data, see
\code{\link[=create_summarizedcounts]{create_summarizedcounts()}}.}

\item{\code{feature_counts}}{(\code{list()}) FeatureCounts summaries for different types of genomic
features.}

\item{\code{salmon_quant}}{(\code{list()})\cr
Salmon quant using the actual library strandedness,imported by tximport.}

\item{\code{salmon_quant_opposite}}{(\code{list()})\cr
Salmon quant using strandedness info opposite to actual
library strandedness, imported by tximport.}

\item{\code{global_correction}}{(\code{matrix()})\cr
Count matrix corrected for gDNA contamination by using
the "Global" method.}

\item{\code{gc_correction}}{(\code{matrix()})\cr
Count matrix corrected for gDNA contamination by using
the "GC\%" method.}

\item{\code{ir_correction}}{(\code{matrix()})\cr
Count matrix corrected for gDNA contamination by using
the "IR\%" method.}

\item{\code{stranded_correction}}{(\code{matrix()})\cr
Count matrix corrected for gDNA contamination by using
the method dedicated to stranded RNA-seq data.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SummarizedCounts-new}{\code{SummarizedCounts$new()}}
\item \href{#method-SummarizedCounts-add_ir_rate}{\code{SummarizedCounts$add_ir_rate()}}
\item \href{#method-SummarizedCounts-set_feature_counts}{\code{SummarizedCounts$set_feature_counts()}}
\item \href{#method-SummarizedCounts-set_salmon_quant}{\code{SummarizedCounts$set_salmon_quant()}}
\item \href{#method-SummarizedCounts-set_salmon_quant_opposite}{\code{SummarizedCounts$set_salmon_quant_opposite()}}
\item \href{#method-SummarizedCounts-set_global_correction}{\code{SummarizedCounts$set_global_correction()}}
\item \href{#method-SummarizedCounts-set_gc_correction}{\code{SummarizedCounts$set_gc_correction()}}
\item \href{#method-SummarizedCounts-set_ir_correction}{\code{SummarizedCounts$set_ir_correction()}}
\item \href{#method-SummarizedCounts-set_stranded_correction}{\code{SummarizedCounts$set_stranded_correction()}}
\item \href{#method-SummarizedCounts-get_feature_counts}{\code{SummarizedCounts$get_feature_counts()}}
\item \href{#method-SummarizedCounts-get_gene_stat}{\code{SummarizedCounts$get_gene_stat()}}
\item \href{#method-SummarizedCounts-get_exon_stat}{\code{SummarizedCounts$get_exon_stat()}}
\item \href{#method-SummarizedCounts-get_ir_stat}{\code{SummarizedCounts$get_ir_stat()}}
\item \href{#method-SummarizedCounts-get_ir_counts}{\code{SummarizedCounts$get_ir_counts()}}
\item \href{#method-SummarizedCounts-get_ir_anno}{\code{SummarizedCounts$get_ir_anno()}}
\item \href{#method-SummarizedCounts-get_intron_stat}{\code{SummarizedCounts$get_intron_stat()}}
\item \href{#method-SummarizedCounts-get_rRNA_stat}{\code{SummarizedCounts$get_rRNA_stat()}}
\item \href{#method-SummarizedCounts-get_mt_stat}{\code{SummarizedCounts$get_mt_stat()}}
\item \href{#method-SummarizedCounts-get_ct_stat}{\code{SummarizedCounts$get_ct_stat()}}
\item \href{#method-SummarizedCounts-get_gtf_stat}{\code{SummarizedCounts$get_gtf_stat()}}
\item \href{#method-SummarizedCounts-get_gtf_counts}{\code{SummarizedCounts$get_gtf_counts()}}
\item \href{#method-SummarizedCounts-get_salmon_quant}{\code{SummarizedCounts$get_salmon_quant()}}
\item \href{#method-SummarizedCounts-get_salmon_counts}{\code{SummarizedCounts$get_salmon_counts()}}
\item \href{#method-SummarizedCounts-get_salmon_abundance}{\code{SummarizedCounts$get_salmon_abundance()}}
\item \href{#method-SummarizedCounts-get_salmon_length}{\code{SummarizedCounts$get_salmon_length()}}
\item \href{#method-SummarizedCounts-get_salmon_quant_opposite}{\code{SummarizedCounts$get_salmon_quant_opposite()}}
\item \href{#method-SummarizedCounts-get_salmon_opposite_counts}{\code{SummarizedCounts$get_salmon_opposite_counts()}}
\item \href{#method-SummarizedCounts-get_salmon_opposite_abundance}{\code{SummarizedCounts$get_salmon_opposite_abundance()}}
\item \href{#method-SummarizedCounts-clone}{\code{SummarizedCounts$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-new"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.

Note that this object is typically constructed via a wrapper function,
\code{\link[=create_summarizedcounts]{create_summarizedcounts()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$new(lib_strand, col_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lib_strand}}{(\code{integer(1)}) The library's strandedness. It has
three possible values:
\itemize{
\item 0: unstranded, the default;
\item 1: stranded, read 1 (or single-end read) comes from the forward strand;
\item 2: reversely stranded, read 1 (or single-end read) comes from the
reverse strand
For more details, See
https://sailfish.readthedocs.io/en/master/library_type.html.
\code{colData}
}}

\item{\code{col_data}}{(\code{data.frame()}) A data frame with rows corresponding to
samples. For unstranded RNA-seq data, it at least contains the
following columns: \code{sample_name}, \code{BAM_file}, \code{group},
\code{salmon_quant_file}, and \code{batch} if the data were generated in more
than one batches. For stranded RNA-seq
data, an extra column, \code{salmon_quant_file_opposite_strand}, should be
included.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-add_ir_rate"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-add_ir_rate}{}}}
\subsection{Method \code{add_ir_rate()}}{
Add IR\% to the col_data by merging data frames
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$add_ir_rate(IR_rate)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{IR_rate}}{(\code{data.frame()})\cr
A data frame with sample_name as rownames, and a single column \code{IR_rate},
stroing the percentage of reads mapping to intergenic regions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-set_feature_counts"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-set_feature_counts}{}}}
\subsection{Method \code{set_feature_counts()}}{
Set feature_counts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$set_feature_counts(feature_counts_list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_counts_list}}{(\code{data.frame()})\cr
The feature_counts list contains the following elements: "gene", "exon",
"intergenic_region", "intronic_region", "rRNA", "mitochondrion", "gtf",
"chloroplast". For genomic features, gene, exon, intron, rRNA,
mitochondrion, and chloroplast, only the \code{stat} elements of the
\code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} oupt is stored; for intergenic region,
the \code{stat}, \code{annotation} and \code{counts} elements are stored; for GTF-based
summarization, the \code{stat} and \code{counts} elements are stored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-set_salmon_quant"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-set_salmon_quant}{}}}
\subsection{Method \code{set_salmon_quant()}}{
set salmon_quant
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$set_salmon_quant(tximport_list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tximport_list}}{(\code{list()})\cr
A three-element \code{\link[=tximport]{tximport()}} list aggregated from Salmon quantification
results genrated by using the correct library strandedness information,
containing \code{counts}, \code{abundance}, and \code{length}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-set_salmon_quant_opposite"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-set_salmon_quant_opposite}{}}}
\subsection{Method \code{set_salmon_quant_opposite()}}{
set salmon_quant_opposite
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$set_salmon_quant_opposite(tximport_list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tximport_list}}{(\code{list()})\cr
A three-element \code{\link[=tximport]{tximport()}} list aggregated from Salmon quantification
results genrated by using the opposite library strandedness information,
containing \code{counts}, \code{abundance}, and \code{length}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-set_global_correction"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-set_global_correction}{}}}
\subsection{Method \code{set_global_correction()}}{
Set express matrix by using the "Global" method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$set_global_correction(corrected_expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{corrected_expr}}{(\code{matrix()})\cr
A count matrix containing expression corrected by the "Global" method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-set_gc_correction"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-set_gc_correction}{}}}
\subsection{Method \code{set_gc_correction()}}{
Set express matrix by using the "GC\%" method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$set_gc_correction(corrected_expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{corrected_expr}}{(\code{matrix()})\cr
A count matrix containing expression corrected by the "GC\%" method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-set_ir_correction"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-set_ir_correction}{}}}
\subsection{Method \code{set_ir_correction()}}{
Set express matrix by using the "IR\%" method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$set_ir_correction(corrected_expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{corrected_expr}}{(\code{matrix()})\cr
A matrix containing expression corrected by the "Global" method in the form
of log2(count per million).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-set_stranded_correction"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-set_stranded_correction}{}}}
\subsection{Method \code{set_stranded_correction()}}{
Set express matrix by using the method dedicated to stranded RNA-seq data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$set_stranded_correction(corrected_expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{corrected_expr}}{(\code{matrix()})\cr
A count matrix containing expression corrected by the method dedicated to
stranded RNA-seq data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of \link{SummarizedCounts}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_feature_counts"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_feature_counts}{}}}
\subsection{Method \code{get_feature_counts()}}{
Get featureCounts output as a whole list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_feature_counts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing the following elements: "gene", "exon",
"intergenic_region", "intronic_region", "rRNA", "mitochondrion", "gtf",
"chloroplast". For genomic features, gene, exon, intron, rRNA,
mitochondrion, and chloroplast, only the \code{stat} elements of the
\code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output is stored; for intergenic region,
the \code{stat}, \code{annotation} and \code{counts} elements are stored; for GTF-based
summarization, the \code{stat} and \code{counts} elements are stored.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_gene_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_gene_stat}{}}}
\subsection{Method \code{get_gene_stat()}}{
Get featureCounts \code{stat} for the \verb{gene-coding regions}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_gene_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{gene-coding regions}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_exon_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_exon_stat}{}}}
\subsection{Method \code{get_exon_stat()}}{
Get featureCounts \code{stat} for the \verb{exon regions}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_exon_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{exon regions}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_ir_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_ir_stat}{}}}
\subsection{Method \code{get_ir_stat()}}{
Get featureCounts \code{stat} for the \verb{intergenic regions}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_ir_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{intergenic regions}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_ir_counts"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_ir_counts}{}}}
\subsection{Method \code{get_ir_counts()}}{
Get featureCounts \code{counts} for the \verb{intergenic regions}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_ir_counts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{counts} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{intergenic regions}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_ir_anno"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_ir_anno}{}}}
\subsection{Method \code{get_ir_anno()}}{
Get featureCounts \code{annotation} for the \verb{intergenic regions}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_ir_anno()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{annotation} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{intergenic regions}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_intron_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_intron_stat}{}}}
\subsection{Method \code{get_intron_stat()}}{
Get featureCounts \code{stat} for the \verb{intronic regions}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_intron_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{intronic regions}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_rRNA_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_rRNA_stat}{}}}
\subsection{Method \code{get_rRNA_stat()}}{
Get featureCounts \code{stat} for the \verb{rRNA-encoding regions}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_rRNA_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{rRNA-encoding regions}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_mt_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_mt_stat}{}}}
\subsection{Method \code{get_mt_stat()}}{
Get featureCounts \code{stat} for the \verb{mitochondiral genome}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_mt_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{mitochondiral genome}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_ct_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_ct_stat}{}}}
\subsection{Method \code{get_ct_stat()}}{
Get featureCounts \code{stat} for the \verb{chloroplast genome}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_ct_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{chloroplast genome}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_gtf_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_gtf_stat}{}}}
\subsection{Method \code{get_gtf_stat()}}{
Get featureCounts \code{stat} for the \verb{GTF metagene}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_gtf_stat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{stat} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{GTF metagenes}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_gtf_counts"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_gtf_counts}{}}}
\subsection{Method \code{get_gtf_counts()}}{
Get featureCounts \code{counts} for the \verb{GTF metagene}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_gtf_counts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the \code{counts} elements of the \code{\link[Rsubread:featureCounts]{Rsubread::featureCounts()}} output
for the \verb{GTF metagenes}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_salmon_quant"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_salmon_quant}{}}}
\subsection{Method \code{get_salmon_quant()}}{
Get \code{\link[=tximport]{tximport()}} output as a whole list, including the three matrices
\code{counts}, \code{abundance}, and \code{length}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_salmon_quant()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of three elements, \code{counts}, \code{abundance}, and \code{length} of
the \code{\link[tximport:tximport]{tximport::tximport()}} output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_salmon_counts"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_salmon_counts}{}}}
\subsection{Method \code{get_salmon_counts()}}{
Get \code{\link[=tximport]{tximport()}} output as a whole list, only including the \code{counts} matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_salmon_counts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the  \code{counts} element of the \code{\link[tximport:tximport]{tximport::tximport()}} output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_salmon_abundance"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_salmon_abundance}{}}}
\subsection{Method \code{get_salmon_abundance()}}{
Get \code{\link[=tximport]{tximport()}} output as a whole list, only including the \code{abundance}
matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_salmon_abundance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the  \code{abundance} element of the \code{\link[tximport:tximport]{tximport::tximport()}} output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_salmon_length"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_salmon_length}{}}}
\subsection{Method \code{get_salmon_length()}}{
Get \code{\link[=tximport]{tximport()}} output as a whole list, only including the \code{length}
matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_salmon_length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the  \code{length} element of the \code{\link[tximport:tximport]{tximport::tximport()}} output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_salmon_quant_opposite"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_salmon_quant_opposite}{}}}
\subsection{Method \code{get_salmon_quant_opposite()}}{
Get \code{\link[=tximport]{tximport()}} output as a whole list, including the three matrices
\code{counts}, \code{abundance}, and \code{length}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_salmon_quant_opposite()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of three elements, \code{counts}, \code{abundance}, and \code{length} of
the \code{\link[tximport:tximport]{tximport::tximport()}} output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_salmon_opposite_counts"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_salmon_opposite_counts}{}}}
\subsection{Method \code{get_salmon_opposite_counts()}}{
Get \code{\link[=tximport]{tximport()}} output as a whole list, only including the \code{count}
matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_salmon_opposite_counts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the  \code{counts} element of the \code{\link[tximport:tximport]{tximport::tximport()}} output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-get_salmon_opposite_abundance"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-get_salmon_opposite_abundance}{}}}
\subsection{Method \code{get_salmon_opposite_abundance()}}{
Get \code{\link[=tximport]{tximport()}} output as a whole list, only including the \code{abundance}
matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$get_salmon_opposite_abundance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
only the  \code{abundance} element of the \code{\link[tximport:tximport]{tximport::tximport()}} output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummarizedCounts-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SummarizedCounts-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummarizedCounts$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
