% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ligandReceptor_analysis.R
\name{visLigandReceptor}
\alias{visLigandReceptor}
\title{visLigandReceptor}
\usage{
visLigandReceptor(
  sce,
  type = c("pval_heatmap", "pval_dotplot", "group_network", "group_heatmap",
    "lr_network"),
  receptor_type = NULL
)
}
\arguments{
\item{sce}{A singlecellexperiment object}

\item{type}{A character indicates the type of the plot for ligand receptor
restuls visualisation, option includes "pval_heatmap", "pval_dotplot",
"group_network", "group_heatmap", and "lr_network"}

\item{receptor_type}{A character indicates which receptor expression's
ligand receptor results are used to generate the figures.}
}
\value{
A plot visualise the ligand receptor results
}
\description{
A function to visualise ligand receptor analysis
}
\examples{
data(lr_pair_subset, package = "CiteFuse")
data(sce_control_subset, package = "CiteFuse")

sce_control_subset <- normaliseExprs(sce = sce_control_subset,
altExp_name = "ADT",
transform = "zi_minMax")

sce_control_subset <- normaliseExprs(sce = sce_control_subset,
                              altExp_name = "none",
                              exprs_value = "logcounts",
                              transform = "minMax")

sce_control_subset <- ligandReceptorTest(sce = sce_control_subset,
                                  ligandReceptor_list = lr_pair_subset,
                                  cluster = sce_control_subset$SNF_W_louvain,
                                  RNA_exprs_value = "minMax",
                                  use_alt_exp = TRUE,
                                  altExp_name = "ADT",
                                  altExp_exprs_value = "zi_minMax",
                                  num_permute = 100)
visLigandReceptor(sce_control_subset,
type = "pval_heatmap",
receptor_type = "ADT")
}
