% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSNF.R
\name{CiteFuse}
\alias{CiteFuse}
\title{CiteFuse}
\usage{
CiteFuse(
  sce,
  altExp_name = "ADT",
  W_list = NULL,
  gene_select = TRUE,
  dist_cal_RNA = "correlation",
  dist_cal_ADT = "propr",
  ADT_subset = NULL,
  K_knn = 20,
  K_knn_Aff = 30,
  sigma = 0.45,
  t = 10,
  metadata_names = NULL,
  verbose = TRUE,
  topN = 2000
)
}
\arguments{
\item{sce}{a SingleCellExperiment}

\item{altExp_name}{expression name of ADT matrix}

\item{W_list}{affinity list, if it is NULL, the function will calculate it.}

\item{gene_select}{whether highly variable genes will be selected
for RNA-seq to calcualte simlarity matrix using `scran` package}

\item{dist_cal_RNA}{similarity metrics used for RNA matrix}

\item{dist_cal_ADT}{similarity metrics used for ADT matrix}

\item{ADT_subset}{A vector  indicates the subset that will be used.}

\item{K_knn}{Number of nearest neighbours}

\item{K_knn_Aff}{Number of nearest neighbors for computing affinity matrix}

\item{sigma}{Variance for local model for computing affinity matrix}

\item{t}{Number of iterations for the diffusion process.}

\item{metadata_names}{A vector indicates the names of metadata returned}

\item{verbose}{whether print out the process}

\item{topN}{top highly variable genes are used 
variable gene selection 
(see `modelGeneVar` in `scran` package for more details)}
}
\value{
A SingleCellExperiment object with fused matrix results stored
}
\description{
A function to runSNF for CITE seq data
}
\examples{
data("sce_ctcl_subset", package = "CiteFuse")
sce_ctcl_subset <- CiteFuse(sce_ctcl_subset)

}
\references{
B Wang, A Mezlini, F Demir, M Fiume, T Zu, M Brudno, B Haibe-Kains, 
A Goldenberg (2014) Similarity Network Fusion: a fast and effective method 
to aggregate multiple data types on a genome wide scale. 
Nature Methods. Online. Jan 26, 2014
}
