% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{calc_coverage}
\alias{calc_coverage}
\title{Calculate alignment coverage}
\usage{
calc_coverage(x)
}
\arguments{
\item{x}{A \code{\link{CircSeqAlignTkAlign-class}} object generated by
the \code{\link{align_reads}} function.}
}
\value{
A \code{\link{CircSeqAlignTkCoverage-class}} object.
}
\description{
This function calculates alignment coverage
according to the read strand and length from alignment results.
}
\details{
This function calculates alignment coverage from the two BAM files,
\verb{*.clean.t1.bam} and \verb{*.clean.t2.bam},
generated by the \code{\link{align_reads}} function.
The coverage is then sorted by the strand and length of the aligned reads
and summarized into data frames.
}
\examples{
output_dpath <- tempdir()
genome_seq <- system.file(package="CircSeqAlignTk", "extdata", "FR851463.fa")
fq <- system.file(package="CircSeqAlignTk", "extdata", "srna.fq.gz")
ref_index <- build_index(input = genome_seq,
                         output = file.path(output_dpath, 'index'))
aln <- align_reads(input = fq, index = ref_index,
                   output = file.path(output_dpath, 'align_results'))

alncov <- calc_coverage(aln)
}
\seealso{
\code{\link{CircSeqAlignTkAlign-class}},
\code{\link{CircSeqAlignTkCoverage-class}}, \code{\link{align_reads}}
}
