% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{rebin_matrix}
\alias{rebin_matrix}
\title{Transforms a bins x cells count matrix into a larger bins x cells count matrix.}
\usage{
rebin_matrix(
  mat,
  bin_width = 50000,
  custom_annotation = NULL,
  minoverlap = 500,
  verbose = TRUE,
  ref = "hg38",
  nthreads = 1,
  rebin_function = rebin_helper
)
}
\arguments{
\item{mat}{A matrix of peaks x cells}

\item{bin_width}{Width of bins to produce in base pairs (minimum 500) (50000)}

\item{custom_annotation}{A GenomicRanges object specifying the new features
to count the matrix on instead of recounting on genomic bins. If not NULL,
takes predecency over bin_width.}

\item{minoverlap}{Minimum overlap between the original bins and the new features
to consider the peak as overlapping the bin . We recommand to put this
number at exactly half of the original bin size (e.g. 500bp for original bin
size of 1000bp) so that no original bins are counted twice. (500)}

\item{verbose}{Verbose}

\item{ref}{Reference genome to use (hg38)}

\item{nthreads}{Number of threads to use for paralell processing}

\item{rebin_function}{A function to use to rebin the matrix.}
}
\value{
A sparse matrix of larger bins or peaks.
}
\description{
This functions is best used to re-count large number of small bins or peaks
(e.g. <= 5000bp) into equal or larger sized bins. The genome is either cut in
fixed bins (e.g. 50,000bp) or into an user defined number of bins. Bins are
calculated  based on the canconical chromosomes. Note that if peaks are larger
than bins,  or if peaks are overlapping multiple bins, the signal is added
to each bin.
Users can increase the minimum overlap to consider peaks overlapping bins (by
default 150bp, size of a nucleosome) to disminish the number of peaks
overlapping multiple region. Any peak smaller than the minimum overlapp
threshold will be dismissed. Therefore, library size might be slightly
different from peaks to bins if signal was duplicated into multiple bins or
ommitted due to peaks smaller than minimum overlap.
}
\examples{
mat = create_scDataset_raw()$mat
binned_mat = rebin_matrix(mat,bin_width = 10e6)
dim(binned_mat)

}
