% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{create_scExp}
\alias{create_scExp}
\title{Wrapper to create the single cell experiment from count matrix and feature
dataframe}
\usage{
create_scExp(
  datamatrix,
  annot,
  remove_zero_cells = TRUE,
  remove_zero_features = TRUE,
  remove_non_canonical = TRUE,
  remove_chr_M = TRUE,
  mainExpName = "main",
  verbose = TRUE
)
}
\arguments{
\item{datamatrix}{A matrix or sparseMatrix of raw counts. Features x Cells
(rows x columns).}

\item{annot}{A data.frame containing informations on cells. Should have the
same number of rows as the number of columns in datamatrix.}

\item{remove_zero_cells}{remove cells with zero counts ? (TRUE)}

\item{remove_zero_features}{remove cells with zero counts ? (TRUE)}

\item{remove_non_canonical}{remove non canonical chromosomes ?(TRUE)}

\item{remove_chr_M}{remove chromosomes M ? (TRUE)}

\item{mainExpName}{Name of the mainExpName e.g. 'bins', 'peaks'...
("default")}

\item{verbose}{(TRUE)}
}
\value{
Returns a SingleCellExperiment object.
}
\description{
Create the single cell experiment from (sparse) datamatrix and feature
dataframe containing feature names and location. Also optionally removes zero
count Features, zero count Cells, non canconical chromosomes, and chromosome
M. Calculates QC Metrics (scran).
}
\examples{
raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
scExp

}
