% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_number.R
\name{calculate_CNA}
\alias{calculate_CNA}
\title{Estimate copy number alterations in cytobands}
\usage{
calculate_CNA(
  scExp,
  control_samples = unique(scExp$sample_id)[1],
  ref_genome = c("hg38", "mm10", "ce11")[1],
  quantiles_to_define_gol = c(0.05, 0.95)
)
}
\arguments{
\item{scExp}{A SingleCellExperiment with "logRatio_cytoBand" reducedDim slot
filled. See  \code{\link{calculate_logRatio_CNA}}}

\item{control_samples}{Sample IDs of the normal sample to take as
reference.}

\item{ref_genome}{Reference genome ('hg38' or 'mm10')}

\item{quantiles_to_define_gol}{Quantiles of normal log2-ratio distribution
below/above which cytoband is considered to be a loss/gain. (c(0.05,0.95)).
See \code{\link{calculate_gain_or_loss}}}
}
\value{
The SCE with the fraction of reads, log2-ratio and gain or loss
in each cytobands in each cells (of dimension cell x cytoband)
in the  reducedDim slots.
}
\description{
Cytobands are considered large enough in order that a variation at the
cytoband level is not considered as an epigenetic event but as a genetic
event, e.g. Copy Number Alterations. The function successively :
\itemize{
\item Calculates the fraction of reads in each cytoband (FrCyto). See \code{\link{calculate_cyto_mat}}
\item Calculates the log2-ratio FrCyto of each cell by the average FrCyto in normal cells. See  \code{\link{calculate_logRatio_CNA}}
\item Estimates if there was a gain or a loss of copy in each cyto band. See  \code{\link{calculate_gain_or_loss}}
}

The corresponding matrices are accessibles in the reducedDim slots
"cytoBands", "logRatio_cytoBands" and "gainOrLoss_cytoBands" respectively.
}
\examples{

data("scExp")
scExp = calculate_CNA(scExp,  control_samples = unique(scExp$sample_id)[1],
ref_genome="hg38", quantiles_to_define_gol = c(0.05,0.95))
SingleCellExperiment::reducedDim(scExp, "cytoBand")
SingleCellExperiment::reducedDim(scExp, "logRatio_cytoBand")
SingleCellExperiment::reducedDim(scExp, "gainOrLoss_cytoBand")

}
