% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnnotation.R
\name{getAnnotation}
\alias{getAnnotation}
\title{Obtain the TSS, exon or miRNA annotation for the specified species}
\usage{
getAnnotation(
  mart,
  featureType = c("TSS", "miRNA", "Exon", "5utr", "3utr", "ExonPlusUtr", "transcript")
)
}
\arguments{
\item{mart}{A mart object, see useMart of biomaRt package for details.}

\item{featureType}{TSS, miRNA, Exon, 5'UTR, 3'UTR, transcript or Exon plus
UTR. The default is TSS.}
}
\value{
\link[GenomicRanges:GRanges-class]{GRanges} with slot start holding
the start position of the feature, slot end holding the end position of the
feature, slot names holding the id of the feature, slot space holding the
chromosome location where the feature is located. In addition, the following
variables are included.  \item{list("strand")}{1 for positive strand and -1
for negative strand where the feature is located}
\item{list("description")}{description of the feeature such as gene}
}
\description{
Obtain the TSS, exon or miRNA annotation for the specified species using the
biomaRt package
}
\note{
For featureType of TSS, start is the transcription start site if
strand is 1 (plus strand), otherwise, end is the transcription start site.
\cr\cr
Note that the version of the annotation db must match with the genome used
for mapping because the coordinates may differ for different genome releases.
 For example, if you are using Mus_musculus.v103 for mapping, 
 you'd best also use EnsDb.Mmusculus.v103 for annotation. 
 See Examples for more info.
}
\examples{

if (interactive() || Sys.getenv("USER")=="jianhongou" )
{
  library(biomaRt)
  mart <- useMart(biomart="ensembl", dataset="hsapiens_gene_ensembl")
  Annotation <- getAnnotation(mart, featureType="TSS")
}

##########################################################
#  Below are 3 options to fetch the annotation file.     #
##########################################################
if (interactive() || Sys.getenv("USER")=="jianhongou" ){
## Option1: with the AnnotationHub package
library(AnnotationHub)
ah <- AnnotationHub()
EnsDb.Mmusculus <- query(ah, pattern = c("Mus musculus", "EnsDb"))
EnsDb.Mmusculus.v101 <- EnsDb.Mmusculus[[length(EnsDb.Mmusculus)]]
class(EnsDb.Mmusculus.v101)

## Option2: with the getAnnotation() function
library(ChIPpeakAnno)
library(biomaRt)
listMarts()
mart <- useMart(biomart="ENSEMBL_MART_ENSEMBL", 
                dataset="mmusculus_gene_ensembl")
Annotation <- getAnnotation(mart)
# Note that getAnnotation() queries biomart, which is always up-to-date.

## Option3: build your own EnsDb package
## This may need extra effort, and the ?makeEnsembldbPackage 
## is a good starting point.
}
}
\references{
Durinck S. et al. (2005) BioMart and Bioconductor: a powerful
link between biological biomarts and microarray data analysis.
Bioinformatics, 21, 3439-3440.
}
\author{
Lihua Julie Zhu, Jianhong Ou, Kai Hu
}
\keyword{misc}
