% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{fgseaCelliD}
\alias{fgseaCelliD}
\title{Slight change in fgsea for ram and speed efficiency in CelliD}
\usage{
fgseaCelliD(
  pathways,
  stats,
  nperm = 1000,
  minSize = 10,
  maxSize = 500,
  gseaParam = 0
)
}
\arguments{
\item{pathways}{List of gene sets to check}

\item{stats}{Named vector of gene-level stats. Names should be the same as in 'pathways'}

\item{nperm}{Number of permutations to do. Minimal possible nominal p-value is about 1/nperm}

\item{minSize}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{gseaParam}{GSEA parameter value, all gene-level stats are raised to the power of 'gseaParam' before calculation of GSEA enrichment scores}
}
\value{
A table with GSEA results. Each row corresponds to a tested pathway.
The columns are the following:
\itemize{
  \item pathway -- name of the pathway as in `names(pathway)`;
  \item pval -- an enrichment p-value;
  \item padj -- a BH-adjusted p-value;
  \item ES -- enrichment score, same as in Broad GSEA implementation;
  \item NES -- enrichment score normalized to mean enrichment of random samples of the same size;
  \item nMoreExtreme` -- a number of times a random gene set had a more
     extreme enrichment score value;
  \item size -- size of the pathway after removing genes not present in `names(stats)`.
  \item leadingEdge -- vector with indexes of leading edge genes that drive the enrichment, see \url{http://software.broadinstitute.org/gsea/doc/GSEAUserGuideTEXT.htm#_Running_a_Leading}.
}
}
\description{
Slight change in fgsea for ram and speed efficiency in CelliD
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
ranking <- GetCellGeneRanking(seuratPbmc, reduction = "mca", dims = 1:5)
fgseaCelliD(pathways = Hallmark, stats = ranking[[1]])
}
