% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkCelliDArg}
\alias{checkCelliDArg}
\alias{checkCelliDArg.Seurat}
\alias{checkCelliDArg.SingleCellExperiment}
\title{Check for CelliD arguments}
\usage{
checkCelliDArg(X, group.by, reduction, dims, features, cells)

\method{checkCelliDArg}{Seurat}(
  X,
  group.by = NULL,
  reduction,
  dims,
  features = NULL,
  cells = NULL
)

\method{checkCelliDArg}{SingleCellExperiment}(
  X,
  reduction,
  dims,
  features = NULL,
  cells = NULL,
  group.by = NULL
)
}
\arguments{
\item{X}{Seurat or SingleCell Experiment Object}

\item{group.by}{Name of meta.data or ColData column.}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use of specified reduction embeddings and loadings.}

\item{features}{Character vector of feature names to subset feature coordinates. If not specified will take all features available from specified reduction loadings.}

\item{cells}{Character vector of cell names to subset cell coordinates. If not specified will take all features available from specified reduction Embeddigns.}
}
\value{
list of corrected arguments if no error is thrown.
}
\description{
Performs multiple check of consistency of the argument provided by the user for different CelliD functions. 
It notably check if the provided features or cells name ar e actually contained in the high level object.
}
