% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{trajSampleNames}
\alias{trajSampleNames}
\alias{trajSampleNames,SingleCellExperiment-method}
\title{GET trajectory sample names}
\usage{
trajSampleNames(object)
}
\arguments{
\item{object}{An object of class \code{SingleCellExperiment}}
}
\value{
An object of class \code{character}
}
\description{
Retrieve names of samples that were aligned onto the trajectory
from a \code{SingleCellExperiment} object.
}
\details{
A trajectory graph can be initially a forest. Trajectory fitting
is performed on one component. This function returns the names of the
samples which are member of the selected component.
}
\examples{
# Example data
data(exSCE)

# Get trajectory samples
trajSampleNames(exSCE)[seq_len(5)]
}
\author{
Daniel C. Ellwanger
}
