% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{trajFeatureNames}
\alias{trajFeatureNames}
\alias{trajFeatureNames,SingleCellExperiment-method}
\title{GET trajectory feature names}
\usage{
trajFeatureNames(object)
}
\arguments{
\item{object}{An object of class \code{SingleCellExperiment}}
}
\value{
An object of class \code{character}
}
\description{
Retrieve names of features that were selected for trajectory reconstruction
from a \code{SingleCellExperiment} object.
}
\details{
Features can be selected prior to trajectory inference.
This method retrieves the user-defined features from a
\code{SingleCellExperiment} object. The return value is a character
vector containing the feature names.
}
\examples{
# Example data
data(exSCE)

# Get trajectory features
trajFeatureNames(exSCE)[seq_len(5)]
}
\author{
Daniel C. Ellwanger
}
