% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{filterTrajFeaturesByDL}
\alias{filterTrajFeaturesByDL}
\alias{filterTrajFeaturesByDL,SingleCellExperiment-method}
\title{Filter trajectory features by Detection Level (DL)}
\usage{
filterTrajFeaturesByDL(sce, threshold, show_plot = TRUE)
}
\arguments{
\item{sce}{An \code{SingleCellExperiment} object}

\item{threshold}{Minimum number of samples; if value < 1 it is interpreted
as fraction, otherwise as absolute sample count}

\item{show_plot}{Indicates if plot should be shown (default: TRUE)}
}
\value{
A \code{character} vector
}
\description{
Filters trajectory features that are detected in a minimum number of
samples.
}
\details{
The detection level denotes the fraction of samples in which a
feature was detected. For each trajectory feature listed in the
CellTrailsSet object the relative number of samples having a feature
expression value greater than 0 is counted. Features that are expressed in
a fraction of all samples greater than \code{threshold} remain labeled as
trajectory feature as listed in the \code{SingleCellExperiment} object,
otherwise they may be not considered for dimensionality reduction,
clustering, and trajectory reconstruction. If the parameter \code{threshold}
fullfills \code{threshold} \eqn{>= 1} it becomes converted to a relative
fraction of the total sample count. Please note that spike-in controls
are ignored and are not listed as trajectory features.
}
\examples{
# Example data
set.seed(1101)
dat <- simulate_exprs(n_features=15000, n_samples=100)

# Create container
alist <- list(logcounts=dat)
sce <- SingleCellExperiment(assays=alist)

# Filter features
tfeat <- filterTrajFeaturesByDL(sce, threshold=2)
head(tfeat)

# Set trajectory features to object
trajFeatureNames(sce) <- tfeat

# Number of features
length(trajFeatureNames(sce)) #filtered
nrow(sce) #total
}
\seealso{
\code{trajFeatureNames}
}
\author{
Daniel C. Ellwanger
}
