% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-summary_barcode.R
\name{bc_summary_barcode}
\alias{bc_summary_barcode}
\alias{bc_summary_barcode,BarcodeObj-method}
\title{Summary and evaluate barcode diversity}
\usage{
bc_summary_barcode(barcodeObj, plot = TRUE, log_x = TRUE)

\S4method{bc_summary_barcode}{BarcodeObj}(barcodeObj, plot = TRUE, log_x = TRUE)
}
\arguments{
\item{barcodeObj}{A BarcodeObj object.}

\item{plot}{A logical value, if TRUE, draw the Lorenz curve and barcode
distribution graphs.}

\item{log_x}{A logical value, if TRUE, the \code{x} axis is logarized.}
}
\value{
A data.frame with the following columns:
\itemize{
  \item \code{total_reads}: total read number.
  \item \code{uniq_barcode}: how many barcodes in the dataset.
  \item \code{shannon_index}: Shannon's diversity index or Shannon–Wiener
    index.
  \item \code{equitability_index}: Shannon's equitability.
  \item \code{bit_index}: Shannon bit information.
}
}
\description{
\code{bc_summary_barcode} evaluates sequence diversity metrics using the
barcodes data in the \code{cleanBc} slot of \code{BarcodeObj} object. It
also generates Lorenz curve and barcode frequency distribution graphs.
}
\details{
Followings are the metrics used for evaluating the barcode diversity:

\emph{Richness}: The unique barcodes number \eqn{R}, it evaluates the
richness of the barcodes.

\emph{Shannon index}: Shannon diversity index is weighted geometric
average of the proportion \eqn{p} of barcodes.
\deqn{ H' = - \sum_{i=1}^{R}p_ilnp_i }

\emph{Equitability index}: Shannon equitability \eqn{E_H} characterize the
evenness of the barcodes, it is a value between 0 and 1, with 1 being
complete evenness.
\deqn{ E_H = H' / H'_{max} = H / ln(R) }

\emph{Bit}:
Shannon entropy \eqn{H}, with a units of bit, 
\deqn{ H = - \sum_{i=1}^{R}p_ilog_2p_i }
}
\examples{
data(bc_obj)

# filter barcode by the depth
bc_obj <- bc_cure_depth(bc_obj)

# Output the summary of the barcodes
bc_summary_barcode(bc_obj)
}
