% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-extract_barcode.R
\name{bc_create_BarcodeObj}
\alias{bc_create_BarcodeObj}
\alias{bc_create_BarcodeObj,matrix-method}
\alias{bc_create_BarcodeObj,data.frame-method}
\title{Create a BarcodeObj object from extracted barcodes data}
\usage{
bc_create_BarcodeObj(x, sample_name = NULL, metadata = NULL, ordered = TRUE)

\S4method{bc_create_BarcodeObj}{matrix}(x, sample_name = NULL, metadata = NULL)

\S4method{bc_create_BarcodeObj}{data.frame}(x, sample_name = NULL, metadata = NULL)
}
\arguments{
\item{x}{The barcodes data, it can be matrix, data.frame with each row as a
barcode each column as a sample. The row names should be given as the barcode
sequences, and the column names can be given as the sample names.}

\item{sample_name}{A character vector, optional, specifying the sample name.}

\item{metadata}{A data.frame, optional, specifying the metadata of each
sample. The row names of the metadata should be the same as the sample
names.}

\item{ordered}{A logical value. If the value is true, the return barcodes
(UMI-barcode tags) are sorted by the read counts.}
}
\value{
A BarcodeObj object.
}
\description{
Create a BarcodeObj object from extracted barcodes data
}
\examples{
data(bc_obj)
m = bc_2matrix(bc_obj)
bc_create_BarcodeObj(m)

}
