% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnrich.R
\name{getEnrich}
\alias{getEnrich}
\title{Enrichment analysis for genes of network}
\usage{
getEnrich(
  genes,
  organismDB,
  keyType,
  ont,
  fdrMethod = "BH",
  fdrThr = 0.05,
  minGSSize = 5,
  maxGSSize = 500
)
}
\arguments{
\item{genes}{Should be an R vector object containing the interesting gene list.}

\item{organismDB}{clusterProfiler supports a lot of different organisms. Users 
can check the following link (https://www.bioconductor.org/packages/release/data/annotation/)
and search for annotations starting with *org.*.}

\item{keyType}{The ID type of the input genes (i.e. SYMBOL, ENTREZID, ENSEMBL, etc.).}

\item{ont}{The functional categories for the enrichment analysis. The available
ontologies are Biological Process (BP), Molecular Function (MF) and 
Cellular Component (CC).}

\item{fdrMethod}{Has five FDR methods: holm, hochberg, hommel, bonferroni, BH,
BY, fdr and none(default: BH).}

\item{fdrThr}{The significant threshold for selected pathways (default: 0.05).}

\item{minGSSize}{Will be exclude the categories with the number of annotated 
genes less than minGSSize for enrichment analysis (default: 5).}

\item{maxGSSize}{Will be exclude the categories with the number of annotated 
genes larger than maxGSSize for enrichment analysis (default: 500).}
}
\value{
Returns an list with the results of the enrichment analysis of the genes and 
a network with the database ID (column 1) and the corresponding
genes (column 2).
}
\description{
Enrichment analysis of a set of genes derived from the network
of any condition using clusterProfiler. Given a vector of genes, this function 
will return the enrichment related to the selected database.
}
\examples{
\dontrun{
# load the CeTF class object resulted from runAnalysis function
library(org.Hs.eg.db)
data(CeTFdemo)

# getting the genes in network of condition 1
genes <- unique(c(as.character(NetworkData(CeTFdemo, 'network1')[, 'gene1']),
                 as.character(NetworkData(CeTFdemo, 'network1')[, 'gene2'])))

# performing getEnrich analysis
cond1 <- getEnrich(genes = genes, organismDB = org.Hs.eg.db, keyType = 'ENSEMBL', 
                   ont = 'BP', fdrMethod = "BH", fdrThr = 0.05, minGSSize = 5, 
                   maxGSSize = 500)
}

}
