% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakePredictionsFromCG.r
\name{MakePredictionsFromCG}
\alias{MakePredictionsFromCG}
\title{make predictions from CG}
\usage{
MakePredictionsFromCG(hypothesisnode, signOfHypothesis, network, delta,
  nodesInExperimentalData = NULL)
}
\arguments{
\item{hypothesisnode}{a hypothesis node}

\item{signOfHypothesis}{the direction of change of hypothesis node}

\item{network}{a computational causal graph}

\item{delta}{the number of edges across which the hypothesis should be followed}

\item{nodesInExperimentalData}{the number of nodes in experimental data}
}
\value{
an matrix containing the relationship between each node and the hypothesis
}
\description{
Create a matrix of predictions for a particular hypothesis - the output
is a matrix containing the relationship between each node and the hypothesis.
The hypothesis provided will be the vertex id of one of the nodes in the network (as an integer). 
The signOfHypothesis variable should be a 1 or -1, indicating up/down regulation
}
\examples{
network <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
cg <- CreateCG(network)
MakePredictionsFromCG('NodeA', +1, cg, 2)
}
\concept{
CausalR
}

