% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetShortestPathsFromCCG.r
\name{GetShortestPathsFromCCG}
\alias{GetShortestPathsFromCCG}
\title{get shortest paths from CCG}
\usage{
GetShortestPathsFromCCG(network, hypothesisnode, targetnode,
  showbothdirs = FALSE, quiet = FALSE)
}
\arguments{
\item{network}{built from iGraph}

\item{hypothesisnode}{hypothesis node ID}

\item{targetnode}{target node ID}

\item{showbothdirs}{where multiple paths from a positive and negative node, FALSE returns only the shortest. Otherwise both are returned.}

\item{quiet}{a flag to suppress output to console. FALSE by default.}
}
\value{
a list of vectors containing the nodes of individual paths
}
\description{
Gets the node names in the shortest path from one node in a CCG to another
}
\examples{
network <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
ccg = CreateCCG(network)
hypothesisnode = 1
targetnode = 10
GetShortestPathsFromCCG (ccg, hypothesisnode, targetnode)
}
\concept{
CausalR
}

