% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processMut.R
\name{processMut}
\alias{processMut}
\title{processMut}
\usage{
processMut(mafList, processMethod = "union")
}
\arguments{
\item{mafList}{A list of MAF data frames after going through
at least one CaMutQC filtration function, and the length of the list <= 3.}

\item{processMethod}{Methods for processing mutations, including "union"
and "intersection". Default: "union".}
}
\value{
A data frame includes mutations after taking union or intersection.
}
\description{
Takes union or intersection on multiple MAF data frame, 
and return 7 important columns.
}
\examples{
maf_MuSE <- vcfToMAF(system.file("extdata/Multi-caller",
"WES_EA_T_1.MuSE.vep.vcf", package="CaMutQC"))
maf_MuSE_f <- mutFilterCom(maf_MuSE, report=FALSE, TMB=FALSE,
PONfile=system.file("extdata", "PON_test.txt", package="CaMutQC"), 
PONformat="txt")
maf_VarScan2 <- vcfToMAF(system.file("extdata/Multi-caller",
"WES_EA_T_1_varscan_filter_snp.vep.vcf", package="CaMutQC"))
maf_VarScan2_f <- mutFilterCom(maf_VarScan2, report=FALSE, TMB=FALSE,
PONfile=system.file("extdata", "PON_test.txt", package="CaMutQC"), 
PONformat="txt")
mafs <- list(maf_MuSE_f, maf_VarScan2_f)
maf_union <- processMut(mafs, processMethod="union")
}
