% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterSB.R
\name{mutFilterSB}
\alias{mutFilterSB}
\title{mutFilterSB}
\usage{
mutFilterSB(maf, method = "SOR", SBscore = 3)
}
\arguments{
\item{maf}{An MAF object, generated by \code{\link{vcfToMAF}} function.}

\item{method}{Method will be used to detect strand bias,
including 'SOR' and 'Fisher'. Default: 'SOR'. SOR: StrandOddsRatio
(https://gatk.broadinstitute.org/hc/en-us/articles/360041849111-
StrandOddsRatio) Fisher's Exat Test: Switch to Phred socre
(https://gatk.broadinstitute.org/hc/en-us/articles/360035532152-Fisher-
s-Exact-Test)}

\item{SBscore}{Cutoff strand bias score used to filter variants.
Default: 3}
}
\value{
An MAF data frame where some variants
have S tag in CaTag column for strand bias filtration
}
\description{
Filter variants based on strand bias.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterSB(maf)
}
