% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cadra_functions.R
\name{generate_permutations}
\alias{generate_permutations}
\title{Random permutation matrix generator}
\usage{
generate_permutations(input_score, n_perm)
}
\arguments{
\item{input_score}{a vector of continuous scores of a molecular phenotype of 
interest such as protein expression, pathway activity, etc.
NOTE: The \code{input_score} object must have names or labels to track 
samples by.}

\item{n_perm}{a number of permutations to generate. This determines
the number of rows in the permutation matrix.}
}
\value{
a matrix of values where each row contains scores of a single 
permuted \code{input_score}.
}
\description{
Produces a random permutation score matrix given a vector of sample-specific
scores representing a phenotypic readout of interest such as protein 
expression, pathway activity, etc.
}
\examples{

# Load pre-simulated scores
data(sim_Scores)

# Set seed for permutation
set.seed(123)

# Define number of permutations
n_perm = 1000

# Generate permuted scores
perm_matrix <- generate_permutations(
  input_score = sim_Scores,
  n_perm = n_perm
)

}
