% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_ctd_gene.R
\name{query_ctd_gene}
\alias{query_ctd_gene}
\title{Function to query CTDbase using gene terminology ( Gene Symbol )}
\usage{
query_ctd_gene(terms, ask = TRUE, verbose = FALSE)
}
\arguments{
\item{terms}{Character vector with the genes used in the query.}

\item{ask}{(default \code{TRUE}) If \code{TRUE} it asks the the persistent
location must be used to save the vocabulary if it was not downloaded
previously.}

\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} is shows
relevant information of each step.}
}
\value{
An object of class \code{\link{CTDdata}}.
}
\description{
This function checks for CTDbase gene vocabulary and query CTDbase
for each one, downloading gene-gene interactions, chemicals
interactions, associated disease, associated KEGG pathways and
associated GO terms.
}
\examples{
# Example in a tryCatch, since we are performing a connection to a server we might
# get a refused connection due to a server rejection. Evaluate the recieved HTTP 
# message to understand if the server is not available or if your IP adress is temporarly restricted
rst <- tryCatch({query_ctd_gene( terms = c( "APP", "HMOX1A", "hmox1" ), verbose = TRUE )}, error = function(w){NULL})
}
