% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_cells.R
\name{scoreCells}
\alias{scoreCells}
\title{Generate CSOA scores from overlap data frame and list of pairs}
\usage{
scoreCells(
  geneSetExp,
  overlapDF,
  setPairs,
  geneSetNames,
  mtMethod = c("by", "bh", "bf"),
  jaccardCutoff = NULL,
  osMethod = c("log", "minmax"),
  pairFileTemplate = NULL,
  keepOverlapOrder = FALSE,
  ...
)
}
\arguments{
\item{geneSetExp}{A gene expression non-sparse matrix with the rows
restricted to the genes for which cell sets will be computed.}

\item{overlapDF}{Overlap data frame.}

\item{setPairs}{A list of overlaps corresponding to each input gene set.}

\item{geneSetNames}{Character vector of names of gene sets.}

\item{mtMethod}{Multiple testing correction method. Options are
Bonferroni ('bf'), Benjamini-Hochberg('bh'), and the default
Benjamini-Yekutieli ('by').}

\item{jaccardCutoff}{A cutoff used in the filtering of edges with low
Jaccard scores. If \code{NULL} (as default), no filtering of such edges
will be performed.}

\item{osMethod}{Method used to compute overlap scores.
Options are "log" and "minmax".}

\item{pairFileTemplate}{Character object used in the naming of the files
where the pair data frames will be saved. Default is \code{NULL} (the pair
data frames will not be saved).}

\item{keepOverlapOrder}{Keep the rank-based order of overlaps in the
pair score file, as opposed to changing it to a pair score-based order.
Ignored if pairFileTemplate is \code{NULL}.}

\item{...}{Additional arguments passed to \code{mtCorrectDF}.}
}
\value{
A data frame whose columns correspond to the CSOA scores of the
input gene sets.
}
\description{
This function scores an overlap data frame using its associated list of
pairs. The overlap data frame is split based on the overlaps corresponding
to each gene set and scored, and the output is rejoined as a data frame.
}
\details{
This function calls \code{scoreCells} to score each gene set
data frame split from the full overlap data frame.
}
\examples{
mat <- matrix(0, 500, 300)
rownames(mat) <- paste0('G', seq(500))
colnames(mat) <- paste0('C', seq(300))
mat[sample(8000)] <- runif(8000, max=13)
genes <- paste0('G', seq(200))
mat[genes, 20:50] <- matrix(runif(200 * 31, min=14, max=15),
nrow=200, ncol=31)
geneSet1 <- paste0('G', seq(1, 150))
geneSet2 <- paste0('G', seq(50, 200))
geneSets <- list(geneSet1, geneSet2)
geneSets <- lapply(geneSets, sort)
setPairs <- lapply(geneSets, getPairs)
pairs <- Reduce(union, setPairs)
genes <- union(geneSet1, geneSet2)
mat <- mat[genes, ]
overlapDF <- generateOverlaps(mat, pairs=pairs)
scoreDF <- scoreCells(mat, overlapDF, setPairs, c('set1', 'set2'))
head(scoreDF)

}
