% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_overlaps.R
\name{processOverlaps}
\alias{processOverlaps}
\title{Process data frame of overlaps of cell sets}
\usage{
processOverlaps(
  overlapDF,
  mtMethod = c("by", "bh", "bf"),
  jaccardCutoff = NULL,
  osMethod = c("log", "minmax"),
  ...
)
}
\arguments{
\item{overlapDF}{Overlap data frame.}

\item{mtMethod}{Multiple testing correction method. Options are
Bonferroni ('bf'), Benjamini-Hochberg('bh'), and the default
Benjamini-Yekutieli ('by').}

\item{jaccardCutoff}{A cutoff used in the filtering of edges with low
Jaccard scores. If \code{NULL} (as default), no filtering of such edges
will be performed.}

\item{osMethod}{Method used to compute overlap scores.
Options are "log" and "minmax".}

\item{...}{Additional arguments passed to \code{mtCorrectDF}.}
}
\value{
A data frame consisting of filtered, ranked and scored cell sets
overlaps
}
\description{
This function filters, ranks and scores previously generated
overlaps of cell sets.
}
\details{
Wrapper around \code{byCorrectDF}, \code{rankOverlaps},
\code{prepareFiltering}, \code{filterOverlaps} and \code{scoreOverlaps}.

If \code{jaccardCutoff} is not \code{NULL}, it also calls
\code{breakWeakTies} between \code{filterOverlaps} and \code{scoreOverlaps}.
}
\examples{
overlapDF <- data.frame(gene1=paste0('G',
c(1, 3, 7, 6, 8, 2, 4, 3, 4, 5)),
gene2=paste0('G',
c(2, 7, 2, 5, 4, 5, 1, 2, 2, 8)),
ratio=runif(10, 2, 10),
pval=runif(10, 0, 1e-10))
processOverlaps(overlapDF)

}
