% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_ranges.R
\name{plotRecurrentRegions}
\alias{plotRecurrentRegions}
\title{Plot recurrent CNV regions}
\usage{
plotRecurrentRegions(regs, genome, chr, pthresh = 0.05)
}
\arguments{
\item{regs}{A \code{\linkS4class{GRanges}}. Typically the result of 
\code{\link{populationRanges}} with \code{est.recur=TRUE}.}

\item{genome}{Character. A valid UCSC genome assembly ID such as 'hg19' or 'bosTau6'.}

\item{chr}{Character. A UCSC-style chromosome name such as 'chr1'.}

\item{pthresh}{Numeric. Significance threshold for recurrence. Defaults to 0.05.}
}
\value{
None. Plots to a graphics device.
}
\description{
Illustrates summarized CNV regions along a chromosome.
}
\examples{

# read in example CNV calls
data.dir <- system.file("extdata", package="CNVRanger")
call.file <- file.path(data.dir, "Silva16_PONE_CNV_calls.csv")
calls <- read.csv(call.file, as.is=TRUE)

# store in a GRangesList
grl <- GenomicRanges::makeGRangesListFromDataFrame(calls, 
   split.field="NE_id", keep.extra.columns=TRUE)

# summarize CNV regions
cnvrs <- populationRanges(grl, density=0.1, est.recur=TRUE)

# plot
plotRecurrentRegions(cnvrs, genome="bosTau6", chr="chr1")

}
\seealso{
\code{Gviz::plotTracks}
}
\author{
Ludwig Geistlinger
}
