% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{update_df}
\alias{update_df}
\title{Dataset line by line construction: add a sample}
\usage{
update_df(mutmatrix, sampleName, ...)
}
\arguments{
\item{mutmatrix}{an existing (sparse) matrix (mutational matrix)}

\item{sampleName}{the row (sample) name}

\item{...}{sample's genotype (0/1 numbers)}
}
\value{
the modified (sparse) matrix (mutational matrix)
}
\description{
Add a sample (a row) to an existing dataset.
This procedure is meant to be used with the "%>%" operator
}
\examples{

require(dplyr)
make_dataset(APC,P53,KRAS)   \%>\%
    update_df("S1", 1, 0, 1) \%>\%
    update_df("S2", 1, 1, 1)


}
