% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{normalizeUPW}
\alias{normalizeUPW}
\title{Up weights normalization}
\usage{
normalizeUPW(g, freqs, no.of.children, A, upWeights)
}
\arguments{
\item{g}{graph (a Directed Acyclic Graph)}

\item{freqs}{observed genotype frequencies}

\item{no.of.children}{number of children for each node}

\item{A}{adjacency matrix of G}

\item{upWeights}{Up weights as computed by computeUPW}
}
\value{
a vector containing the normalized Up weights for each edge
}
\description{
Normalizes up weights so that the sum
of weights of edges entering in a node is 1
}
\examples{
require(dplyr)
require(igraph)
preproc <- example_dataset() \%>\% dataset_preprocessing
samples <- preproc[["samples"]]
freqs   <- preproc[["freqs"]]
labels  <- preproc[["labels"]]
genes   <- preproc[["genes"]]
g <- graph_non_transitive_subset_topology(samples, labels)
# prepare adj matrix
A <- as.matrix(as_adj(g))
# pre-compute exiting edges from each node
no.of.children <- get_no_of_children(A,g)
upWeights <- computeUPW(g, freqs, no.of.children, A)
normalizeUPW(g, freqs, no.of.children, A, upWeights)

}
