% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{chunk_reader}
\alias{chunk_reader}
\title{Gradually read a file from disk}
\usage{
chunk_reader(file_path)
}
\arguments{
\item{file_path}{path to large file}
}
\value{
a list-object containing the function `read` to 
read lines from the given file, and `close` to close the
connection to the file stream.
}
\description{
This function creates a reader to read a text file in batches (or chunks). 
It can be used for very large files that cannot fit in RAM.
}
\examples{
# open connection to file
reader <- chunk_reader(
    system.file("extdata", "paac_jhu_2014_500.maf", package = "CIMICE", mustWork = TRUE)
)

while(TRUE){
    # read a chunk
    chunk <- reader$read(10)
    if(length(chunk) == 0){
        break
    }    
    # --- process chunk ---
}
# close connection
reader$close()

}
