% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{annotate_mutational_matrix}
\alias{annotate_mutational_matrix}
\title{Add samples and genes names to a mutational matrix}
\usage{
annotate_mutational_matrix(M, samples, genes)
}
\arguments{
\item{M}{mutational matrix}

\item{samples}{list of sample names}

\item{genes}{list of gene names}
}
\value{
N with the set row and column names
}
\description{
Given M mutational matrix, add samples as row names, and genes as 
column names. If there are repetitions in row names, these are
solved by adding a sequential identifier to the names.
}
\examples{
require(Matrix)
genes <- c("A", "B", "C")
samples <- c("S1", "S2", "S2")
M <- Matrix(c(0,0,1,0,0,1,0,1,1), ncol=3, sparse=TRUE, byrow = TRUE)

annotate_mutational_matrix(M, samples, genes)

}
