% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{gsea_data}
\alias{gsea_data}
\alias{gsea_data,CEMiTool-method}
\title{Retrieve Gene Set Enrichment Analysis (GSEA) results}
\usage{
gsea_data(cem)

\S4method{gsea_data}{CEMiTool}(cem)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}}
}
\value{
Object of class \code{list} with GSEA data
}
\description{
Retrieve Gene Set Enrichment Analysis (GSEA) results
}
\examples{
# Get example CEMiTool object
data(cem)
# Look at example annotation file
sample_annotation(cem)
# Run GSEA on network modules
cem <- mod_gsea(cem)
# Check results
gsea_data(cem)
}
