% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{adj_data}
\alias{adj_data}
\alias{adj_data,CEMiTool-method}
\alias{adj_data<-}
\alias{adj_data<-,CEMiTool-method}
\title{Get or set adjacency matrix value}
\usage{
adj_data(cem, ...)

\S4method{adj_data}{CEMiTool}(cem)

adj_data(cem) <- value

\S4method{adj_data}{CEMiTool}(cem) <- value
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}}

\item{...}{Optional parameters.}

\item{value}{Object of class \code{matrix} containing adjacency data. Only used
for setting adjacency values to CEMiTool object.}
}
\value{
Object of class \code{matrix} with adjacency values or object of class \code{CEMiTool}.
}
\description{
This function takes a \code{CEMiTool} object containing expression values
and returns a CEMiTool object with an adjacency matrix in the adjacency slot.
}
\examples{
# Get example expression data
data(expr0)
# Initialize new CEMiTool object with expression
cem <- new_cem(expr0, filter=TRUE, apply_vst=FALSE)
# Calculate adjacency matrix with example beta value 8
cem <- get_adj(cem, beta=8)
# Return adjacency matrix
adj <- adj_data(cem)
# Check result
adj[1:5, 1:5]
# Set adjacency matrix to CEMiTool object
adj_data(cem) <- adj

}
