% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{one_batch_matrix}
\alias{one_batch_matrix}
\title{Simulated count matrix from one batch}
\format{
one_batch_matrix is a matrix with 3,000 genes (rows) and 2,000 cells (columns). 
The rows are named with g1, g2, ..., g3000 representing gene 1 to gene 3000; 
the columns are named with rc1, rc2, ..., rc2000 representing raw count 1 to 
raw count 2000.
}
\usage{
data(one_batch_matrix)
}
\description{
This matrix contains raw UMI count matrix simulated from the Negative Binomial(NB) mixture distribution. 
The code simulating this matrix can be found in data-raw/one_batch_simulation.R.
}
\note{
We simulated 3,000 genes and five group of cells with 400 cells each. 
Different cell groups have different mean and dispersion parameters in the 
NB distribution. 
One group of cells was treated as the baseline group with mean parameters
generated from truncated Normal with mean and standard deviation 0.2, 0.1 and 
dispersion generated from truncated with mean and standard deviation 0.5, 0.1. 
For each of the other four groups, 30 genes had mean parameters shifted 
from the baseline group with log2 fold change 2.5.
Dispersion parameters of feature genes were shifted by 
a normalized factor with mean 0 and standard deviation 0.05.
The true cell type labels are in 
'one_batch_matrix_celltype", and the cell clustering results generated from 
two clustering methods are in "one_batch_matrix_label_df".
}
\keyword{datasets}
