% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFreqHeatmap.R
\name{plotFreqHeatmap}
\alias{plotFreqHeatmap}
\title{Cluster frequency heatmap}
\usage{
plotFreqHeatmap(
  x,
  k = "meta20",
  m = NULL,
  normalize = TRUE,
  row_anno = TRUE,
  col_anno = TRUE,
  row_clust = TRUE,
  col_clust = TRUE,
  row_dend = TRUE,
  col_dend = TRUE,
  bars = TRUE,
  perc = FALSE,
  hm_pal = rev(brewer.pal(11, "RdBu")),
  k_pal = .cluster_cols,
  m_pal = k_pal
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{k}{character string specifying the clustering to use;
valid values are \code{names(cluster_codes(x))}.
Cell counts will be computed across these cluster IDs.}

\item{m}{character string specifying a metaclustering 
to include as an annotation when \code{row_anno = TRUE}.}

\item{normalize}{logical specifying whether to Z-score normalize.}

\item{row_anno, col_anno}{logical specifying whether to 
include row/column annotations for clusters/samples; 
for \code{col_anno}, this can be a character vector specifying 
a subset of \code{names(colData(x))} to be included.}

\item{row_clust, col_clust}{logical specifying 
whether rows/columns (clusters/samples) should be 
hierarchically clustered and re-ordered accordingly.}

\item{row_dend, col_dend}{logical specifying 
whether to include row/column dendrograms.}

\item{bars}{logical specifying whether to include a barplot 
of cell counts per cluster as a right-hand side row annotation.}

\item{perc}{logical specifying whether to display 
percentage labels next to bars when \code{bars = TRUE}.}

\item{hm_pal}{character vector of colors to interpolate for the heatmap.}

\item{k_pal, m_pal}{character vector of colors
to use for cluster and merging row annotations.
If less than \code{nlevels(cluster_ids(x, k/m))} 
values are supplied, colors will be interpolated 
via \code{\link[grDevices:colorRamp]{colorRampPalette}}.}
}
\value{
a \code{\link[ComplexHeatmap]{Heatmap-class}} object.
}
\description{
Heatmap of relative cluster abundances (frequencies) by sample.
}
\examples{
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

# complete 
plotFreqHeatmap(sce, k = "meta12", m = "meta8")

# minimal 
plotFreqHeatmap(sce, k = "meta10",
  normalize = FALSE, bars = FALSE,
  row_anno = FALSE, col_anno = FALSE,
  row_clust = FALSE, col_clust = FALSE)
  
# customize colors & annotations
plotFreqHeatmap(sce, 
  k = "meta7", m = "meta4",
  col_anno = "condition",
  hm_pal = c("navy", "grey95", "gold"),
  k_pal = hcl.colors(7, "Set 2"),
  m_pal = hcl.colors(4, "Dark 3"))

}
\seealso{
\code{\link{plotAbundances}}, 
\code{\link{plotExprHeatmap}}, 
\code{\link{plotMultiHeatmap}},
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
