% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignPrelim.R
\name{assignPrelim}
\alias{assignPrelim}
\title{Single-cell debarcoding (1)}
\usage{
assignPrelim(x, bc_key, assay = "exprs", verbose = TRUE)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{bc_key}{the debarcoding scheme. A binary matrix with sample names as
row names and numeric masses as column names OR a vector of numeric masses 
corresponding to barcode channels. When the latter is supplied, 
`assignPrelim` will create a scheme of the appropriate format internally.}

\item{assay}{character string specifying which assay to use.}

\item{verbose}{logical. Should extra information on progress be reported?}
}
\value{
a \code{SingleCellExperiment} structured as follows: 
\describe{
\item{\code{assays}}{
\itemize{
\item \code{counts} - raw counts
\item \code{exprs} - arcsinh-transformed counts
\item \code{scaled} - population-wise scaled 
expression using (95\%)-quantiles as boundaries
}
}
\item{\code{colData}}{
\itemize{
\item \code{bc_id} - numeric vector of barcode assignments
\item \code{delta} - separation between
positive and negative barcode populations
}
}
\item{\code{metadata}}{
\itemize{
\item \code{bc_key} - the input debarcoding scheme
}
}
}
}
\description{
Assigns a preliminary barcode ID to each event.
}
\examples{
data(sample_ff, sample_key)
sce <- prepData(sample_ff)
sce <- assignPrelim(sce, sample_key)
table(sce$bc_id)

}
\references{
Zunder, E.R. et al. (2015).
Palladium-based mass tag cell barcoding with a doublet-filtering scheme 
and single-cell deconvolution algorithm.
\emph{Nature Protocols} \bold{10}, 316-333.
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
