% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCodes.R
\name{plotCodes}
\alias{plotCodes}
\title{tSNE and PCA on SOM codes}
\usage{
plotCodes(x, k = "meta20", k_pal = .cluster_cols)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{k}{character string. Specifies the clustering to use for color coding.}

\item{k_pal}{character string specifying the cluster color palette;
If less than \code{nlevels(cluster_ids(x, k))} are supplied, colors will 
be interpolated via \code{\link[grDevices:colorRamp]{colorRampPalette}}.}
}
\value{
a \code{ggplot} object.
}
\description{
Plots the tSNE and PCA representing the SOM codes as inferred
by \pkg{FlowSOM}. Sizes are scaled to the total number of events assigned 
to each cluster, and points are color according to their cluster ID upon 
\pkg{ConsensusClusterPlus} metaclustering into \code{k} clusters.
}
\examples{
# construct SCE & run clustering
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

plotCodes(sce, k = "meta14")

# use custom cluster color palette
plotCodes(sce, k = "meta12",
  k_pal = c("lightgrey", "cornflowerblue", "navy"))

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
