% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{createCARDfreeObject}
\alias{createCARDfreeObject}
\title{Create the CARD object}
\usage{
createCARDfreeObject(
  markerlist,
  spatial_count,
  spatial_location,
  mincountgene = 100,
  mincountspot = 5,
  spe = NULL
)
}
\arguments{
\item{markerlist}{a list of marker genes, with each element of the list
being the vector of cell type specific marker genes}

\item{spatial_count}{Raw spatial resolved transcriptomics data, each column
is a spatial location, and each row is a gene.}

\item{spatial_location}{data frame, with two columns representing the x and
y coordinates of the spatial location. The rownames of this data frame
should match eaxctly with the columns of the spatial_count.}

\item{mincountgene}{Minimum counts for each gene}

\item{mincountspot}{Minimum counts for each spatial location}

\item{spe}{a \code{SpatialExperiment} object containing spatial data in
the \code{counts} assay, and spatial coordinates in the spatialCoords.}
}
\value{
Returns CARDfree object with filtered spatial count and marker gene
list.
}
\description{
Create the CARD object
}
