% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compoundQuantiles.R
\docType{methods}
\name{getAtomCount,compoundQuantiles-method}
\alias{getAtomCount}
\alias{getAtomCount,compoundQuantiles-method}
\title{The number of atoms of the given element}
\usage{
\S4method{getAtomCount}{compoundQuantiles}(object, element, mass, quantile)
}
\arguments{
\item{object}{A compoundQuantiles object}

\item{element}{The element of interest specified by element symbol}

\item{mass}{The mass of the compound specified in atomic units (=dalton)}

\item{quantile}{The quantile level for the number of atoms}
}
\value{
The number of atoms
}
\description{
Returns the number of atoms the specified element in a compound of the specified mass for the specified quantile level
}
\examples{
cpObj <- compoundQuantiles()

compoundMass <- 503
quantileLow   <- 0.05
quantileHigh  <- 0.95
element <- "C"
countLow  <- getAtomCount(object = cpObj, element = element, mass = compoundMass, quantile = quantileLow)
countHigh <- getAtomCount(object = cpObj, element = element, mass = compoundMass, quantile = quantileHigh)

print(paste("The ", (quantileHigh - quantileLow) * 100, "\% confidence interval for the number of atoms of element ", element, " in a compound with mass ", compoundMass, " is [", countLow, ", ", countHigh, "]", sep = ""))
}
\author{
Hendrik Treutler
}

