% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R
\name{librarySizes}
\alias{librarySizes}
\alias{librarySizes,CAGEexp-method}
\title{Extracting library sizes from CAGEr objects}
\usage{
librarySizes(object)

\S4method{librarySizes}{CAGEexp}(object)
}
\arguments{
\item{object}{A CAGEexp object.}
}
\value{
Returns an integer vector of total number of CAGE tags (library size) for all CAGE
datasets in the CAGEr object.
}
\description{
Extracts the library sizes (total number of CAGE tags) for all CAGE datasets
from \code{\link{CAGEexp}} objects.
}
\details{
Library sizes are calculated when loading data with the \code{getCTSS}
function and stored in the \code{librarySizes} column of the \code{colData} of
\code{CAGEexp} objects.
}
\examples{
librarySizes(exampleCAGEexp)

}
\seealso{
\code{\link{getCTSS}}

Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle
}
\concept{CAGEr accessor methods}
