% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R, R/SetMethods.R
\name{inputFilesType}
\alias{inputFilesType}
\alias{inputFilesType,CAGEexp-method}
\alias{inputFilesType<-}
\alias{inputFilesType<-,CAGEexp-method}
\title{Input file formats for CAGEr objects}
\usage{
inputFilesType(object)

\S4method{inputFilesType}{CAGEexp}(object)

inputFilesType(object) <- value

\S4method{inputFilesType}{CAGEexp}(object) <- value
}
\arguments{
\item{object}{A CAGEexp object.}

\item{value}{A character vector with one file type per sample.}
}
\value{
Returns the type of the file format of CAGE data input files,
\emph{e.g.} \code{"bam"} or \code{"ctss"}.  In the case of \code{CAGEexp}
objects, the return value is character vector with one member per sample.
}
\description{
Get or set the information on the type of CAGE data input
files from \code{\link{CAGEexp}} objects.
}
\details{
The following input file types are supported:

\itemize{
\item{\code{bam}: A single-ended BAM file.}

\item{\code{bamPairedEnd}: A paired-ended BAM file.}

\item{\code{bed}: A BED file where each line counts for one molecule.}

\item{\code{bedScore}: A BED file where the score indicates a number of
counts for a given alignment.}

\item{\code{CAGEscanMolecule}: Experimental.  For the CAGEscan 3.0 pipeline.}

\item{\code{ctss}: A tabulation-delimited file describing CAGE Transcription
Start Sites (CTSS) with four columns indicating \emph{chromosome},
\emph{1-based coordinate}, \emph{strand} and \emph{score} respectively.}

\item{\code{CTSStable}}

\item{\code{FANTOM5}}

\item {\code{ENCODE}}

\item{\code{FANTOM3and4}}

\item{\code{ZebrafishDevelopment}}
}
}
\examples{
inputFilesType(exampleCAGEexp)

}
\seealso{
\code{\link{getCTSS}}

Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}

Other CAGEr setter methods: 
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{sampleLabels}()},
\code{\link{setColors}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr accessor methods}
\concept{CAGEr setter methods}
