% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{CTSStoGenes}
\alias{CTSStoGenes}
\alias{CTSStoGenes,CAGEexp-method}
\title{Make a gene expression table.}
\usage{
CTSStoGenes(object)

\S4method{CTSStoGenes}{CAGEexp}(object)
}
\arguments{
\item{object}{A \code{CAGEexp} object that was annotated with the \code{\link[=annotateCTSS]{annotateCTSS()}}
function.}
}
\value{
The input object with the following modifications:
\itemize{
\item A new \code{geneExpMatrix} experiment containing gene expression levels as
a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}} object with one assay called \code{counts}, which
is plain \code{matrix} of integers.  (This plays better than \verb{Rle DataFrames}
when interfacing with downstream packages like DESeq2, and since the number of
genes is limited, a \code{matrix} will not cause problems of performance.)
\item New \code{genes} column data added, indicating total number of gene symbols
detected per library.
\item New \code{unannotated} column data added, indicating for each sample the
number of counts that did not overlap with a known gene.
}
}
\description{
Add a gene expression table in the \code{GeneExpSE} experiment slot of an
annotated \code{\link{CAGEexp}} object.
}
\examples{
CTSStoGenes(exampleCAGEexp)
all( librarySizes(exampleCAGEexp) -
     colSums(SummarizedExperiment::assay(GeneExpSE(exampleCAGEexp))) ==
     exampleCAGEexp$unannotated)

}
\seealso{
\code{\link[=annotateCTSS]{annotateCTSS()}}.

Other CAGEr object modifiers: 
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}

Other CAGEr gene expression analysis functions: 
\code{\link{GeneExpDESeq2}()},
\code{\link{ranges2genes}()}
}
\author{
Charles Plessy
}
\concept{CAGEr gene expression analysis functions}
\concept{CAGEr object modifiers}
