% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R
\name{CTSSnormalizedTpmDF}
\alias{CTSSnormalizedTpmDF}
\alias{CTSSnormalizedTpmDF,CAGEexp-method}
\alias{CTSSnormalizedTpmGR}
\alias{CTSSnormalizedTpmGR,CAGEexp-method}
\title{Extracting normalized CAGE signal for TSSs from CAGEr objects}
\usage{
CTSSnormalizedTpmDF(object)

\S4method{CTSSnormalizedTpmDF}{CAGEexp}(object)

CTSSnormalizedTpmGR(object, samples)

\S4method{CTSSnormalizedTpmGR}{CAGEexp}(object, samples)
}
\arguments{
\item{object}{A \code{CAGEexp} object.}

\item{samples}{The name of sample(s) as reported by \code{sampleLabels(object)},
or the number identifying the sample(s).}
}
\value{
\code{CTSSnormalizedTpmDF} returns a \code{DataFrame} of normalised expression values.
}
\description{
Extracts the normalized CAGE signal for all detected TSSs
in all CAGE datasets from \code{\link{CAGEexp}} objects.
}
\examples{
CTSSnormalizedTpmDF(exampleCAGEexp)

CTSSnormalizedTpmGR(exampleCAGEexp, 1)
exampleCAGEexp |> CTSSnormalizedTpmGR("all") 
 
}
\seealso{
\code{\link{normalizeTagCount}}

Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr accessor methods}
