% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAGEexp.R
\docType{class}
\name{CAGEexp-class}
\alias{CAGEexp-class}
\alias{CAGEexp}
\alias{coerce,data.frame,CAGEexp-method}
\title{CAGEr class to hold all data and metadata about one CAGE experiment.}
\description{
The \code{\link{CAGEr}} class is a \code{\link[MultiAssayExperiment:MultiAssayExperiment]{MultiAssayExperiment::MultiAssayExperiment}} object containing all data
and metadata about a set of CAGE libraries.  It replaced the CAGEset class
in 2017.  The main difference is that the expression data is stored
in \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}} objects of \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle}}-encoded expression values, instead of plain
\code{data.frame}s.  With large datasets, this saves considerable amounts of memory.
}
\details{
If \code{genomeName} is \code{NULL}, checks of chromosome names will be
disabled and G-correction will not be possible.  See
\url{https://support.bioconductor.org/p/86437/} for an example on how to create a
\emph{BSgenome} package.

Sample labels must be \emph{syntactically valid} in the sense of the \code{\link[=make.names]{make.names()}}
function, because they will be used as column names in some tables.
}
\section{Slots}{

\describe{
\item{\code{metadata}}{A list that must at least contain a \code{genomeName} member.}
}}

\examples{
pathsToInputFiles <- list.files( system.file("extdata", package = "CAGEr")
                               , "ctss$"
                               , full.names = TRUE)
sampleLabels <- sub( ".chr17.ctss", "", basename(pathsToInputFiles))

# The CAGEexp object can be created using specific constructor commands
                              
exampleCAGEexp <-
  CAGEexp( genomeName     = "BSgenome.Drerio.UCSC.danRer7"
         , inputFiles     = pathsToInputFiles
         , inputFilesType = "ctss"
         , sampleLabels   = sub( ".chr17.ctss", "", basename(pathsToInputFiles)))
         
# Alternatively, it can be created just like another MultiAssayExperiment.
# This is useful when providing pre-existing colData with many columns.

exampleCAGEexp <-
  CAGEexp( metadata = list(genomeName = "BSgenome.Drerio.UCSC.danRer7")
         , colData  = DataFrame( inputFiles     = pathsToInputFiles
                               , sampleLabels   = sampleLabels
                               , inputFilesType = "ctss"
                               , row.names      = sampleLabels))


# Expression data is loaded by the getCTSS() function, that also calculates
# library sizes and store them in the object's column data.

exampleCAGEexp <- getCTSS(exampleCAGEexp)
librarySizes(exampleCAGEexp)
colData(exampleCAGEexp)

# CTSS data is stored internally as a SummarizedExperiemnt that can be retreived
# as a whole, or as GRanges, or as an expression DataFrame.

CTSStagCountSE(exampleCAGEexp)
CTSScoordinatesGR(exampleCAGEexp)
CTSStagCountDF(exampleCAGEexp)

# Columns of the "colData" table are accessible directly via the "$" operator.

exampleCAGEexp$l1 <- CTSStagCountDF(exampleCAGEexp) |> sapply ( \(col) sum(col > 0) )
exampleCAGEexp$l1

}
\seealso{
\code{\link{make.names}}
}
