% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape.R
\name{calcShape}
\alias{calcShape}
\alias{calcShape,GRanges,GRanges-method}
\alias{calcShape,RangedSummarizedExperiment,GRanges-method}
\alias{calcShape,GRanges,RangedSummarizedExperiment-method}
\alias{calcShape,GRanges,GPos-method}
\alias{calcShape,RangedSummarizedExperiment,RangedSummarizedExperiment-method}
\title{Calculate Tag Cluster shapes}
\usage{
calcShape(object, pooled, ...)

\S4method{calcShape}{GRanges,GRanges}(object, pooled, outputColumn = "IQR", shapeFunction = shapeIQR, ...)

\S4method{calcShape}{RangedSummarizedExperiment,GRanges}(object, pooled, ...)

\S4method{calcShape}{GRanges,RangedSummarizedExperiment}(object, pooled, ...)

\S4method{calcShape}{GRanges,GPos}(object, pooled, ...)

\S4method{calcShape}{RangedSummarizedExperiment,RangedSummarizedExperiment}(object, pooled, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: TCs.}

\item{pooled}{GenomicRanges or RangedSummarizedExperiment: Pooled CTSS as the
score column.}

\item{...}{additional arguments passed to shapeFunction.}

\item{outputColumn}{character: Name of column to hold shape statistics.}

\item{shapeFunction}{function: Function to apply to each TC (See details).}
}
\value{
object with calculated shape statistics added as a column in rowData
  (or mcols).
}
\description{
Apply a shape-function to the pooled CTSS signal of every Tag Cluster (TC).
}
\examples{
data(exampleCTSSs)
data(exampleUnidirectional)

# Calculate pooled CTSSs using pre-calculated number of total tags:
exampleCTSSs <- calcTPM(exampleCTSSs, totalTags='totalTags')
exampleCTSSs <- calcPooled(exampleCTSSs)

# Calculate shape statistics
calcShape(exampleUnidirectional, pooled=exampleCTSSs,
    outputColumn='entropy', shapeFunction=shapeEntropy)
calcShape(exampleUnidirectional, pooled=exampleCTSSs, outputColumn='IQR',
    shapeFunction=shapeIQR, lower=0.2, upper=0.8)

# See the vignette for how to implement custom shape functions!
}
\seealso{
Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcComposition}()},
\code{\link{calcPooled}()},
\code{\link{calcSupport}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}

Other Shape functions: 
\code{\link{shapeEntropy}()},
\code{\link{shapeIQR}()},
\code{\link{shapeMean}()}
}
\concept{Calculation functions}
\concept{Shape functions}
